#!/usr/bin/bash
# Version: 5.0, Debian11, Zabbix 6.0.38 (2025-03-03)
# Last change: RipEX2 2.2.2.0, Test event
#
# RipEX FW:                     1.9.7.0
# RipEX2 FW:                    2.2.2.0
# RAy FW:                       1.1.18.0, 4.1.51.0
# RAy2 FW:                      2.2.5.0
# RAy3 FW:                      2.0.16.0, 1.1.6.0
# MG102i, MIDGE, MIDGE2 FW:     4.6.40.106

# CONFIGURATION
ZABBIX_SERVER="localhost";
ZABBIX_PORT="10051";
ZABBIX_SENDER="/usr/bin/zabbix_sender";
KEY="snmptraps";
NUMBER_OF_VARS=2;
LOGFILE=/var/log/snmptrap/snmptrap.log
# END OF CONFIGURATION

# define several variables
read host	# example: 192.168.131.231
read udp	# example: UDP: [192.168.131.231]:2049->[10.15.16.118]
read uptime	# example: iso.3.6.1.2.1.1.3.0 0:1:13:37.39
read trapOid 	# example: iso.3.6.1.6.3.1.1.4.1.0 iso.3.6.1.4.1.33555.2.10.7
read firstPar	# example: iso.3.6.1.4.1.33555.2.5.2.7 1
read secondPar	# example: iso.3.6.1.4.1.33555.2.4.1.10 38300
read thirdPar	# example: iso.3.6.1.4.1.33555.2.4.3.1.2 "10.10.10.50"
read fourthPar	# example: iso.3.6.1.4.1.33555.2.6.2.1.5 "10.10.10.205"
read fifthPar	# example: iso.3.6.1.4.1.33555.2.6.2.1.6 2

# LOGGING TRAP INFO
echo "Logging TRAP:" >> ${LOGFILE}
echo `date` >> ${LOGFILE}
host=`echo $udp | cut -f2 -d'[' | cut -f1 -d']'`
echo "Host: $host" >> ${LOGFILE}

# Uncomment these lines if you need the detailed information about the received trap
echo "UDP: $udp" >> ${LOGFILE}
echo "uptime: $uptime" >> ${LOGFILE}
echo "trap: $trapOid" >> ${LOGFILE}
echo "firstPar: $firstPar" >> ${LOGFILE}
echo "secondPar: $secondPar" >> ${LOGFILE}
echo "thirdPar: $thirdPar" >> ${LOGFILE}
echo "fourthPar: $fourthPar" >> ${LOGFILE}
echo "fifthPar: $fifthPar" >> ${LOGFILE}

# Trap OID, Item OID and Trap OID but only with digits from 33555 identifier
trapTmp=`echo $trapOid|cut -f2 -d' '`
racomTrapOid=`echo $trapTmp|cut -f8- -d'.'`

# firstPar
if [ -n "$firstPar" ]; then
	firstParOid=`echo $firstPar|cut -f1 -d' '|cut -f8- -d'.'`
	firstParValue=`echo $firstPar|cut -f2- -d' '`
else
	firstParOid="-"
	firstParValue="-"
fi

# secondPar
if [ -n "$secondPar" ]; then
	econdParOid=`echo $secondPar|cut -f1 -d' '|cut -f8- -d'.'`
	secondParValue=`echo $secondPar|cut -f2- -d' '`
else
	secondParOid="-"
	secondParValue="-"
fi

# thirdPar
if [ -n "$thirdPar" ]; then
	thirdParOid=`echo $thirdPar|cut -f1 -d' '|cut -f7- -d'.'`
	thirdParValue=`echo $thirdPar|cut -f2- -d' '`
	let "NUMBER_OF_VARS += 1";
else
	thirdParOid="-"
	thirdParValue="-"
fi

# fourthPar
if [ -n "$fourthPar" ]; then
	fourthParOid=`echo $fourthPar|cut -f1 -d' '|cut -f7- -d'.'`
	fourthParValue=`echo $fourthPar|cut -f2- -d' '`
	let "NUMBER_OF_VARS += 1";
else
	fourthParOid="-"
	fourthParValue="-"
fi

# fifthPar
if [ -n "$fifthPar" ]; then
	fifthParOid=`echo $fifthPar|cut -f1 -d' '|cut -f7- -d'.'`
	fifthParValue=`echo $fifthPar|cut -f2- -d' '`
	let "NUMBER_OF_VARS += 1";
else
	fifthParOid="-"
	fifthParValue="-"
fi

# Time 
uptime=`echo $uptime|cut -f2 -d ' '`

# Uncomment these lines if you need the detailed information about the received trap
echo "racomTrapOid: $racomTrapOid" >> ${LOGFILE}
echo "firstParOid: $firstParOid" >> ${LOGFILE}
echo "firstParValue: $firstParValue" >> ${LOGFILE}
echo "secondParOid: $secondParOid" >> ${LOGFILE}
echo "secondParValue: $secondParValue" >> ${LOGFILE}
echo "thirdParOid: $thirdParOid" >> ${LOGFILE}
echo "thirdParValue: $thirdParValue" >> ${LOGFILE}
echo "fourthParOid: $fourthParOid" >> ${LOGFILE}
echo "fourthParValue: $fourthParValue" >> ${LOGFILE}
echo "fifthParOid: $fifthParOid" >> ${LOGFILE}
echo "fifthParValue: $fifthParValue" >> ${LOGFILE}

# Do NOT use it until you solve SELinux MySQL rights
# MySQL - get the right HOST according to Zabbix configuration
# export HOME=/root
# ZABBIXHOST=$(echo "select host from zabbix.hosts where host=\"$host\" order by 'hostid' limit 1;" | mysql -N -uroot -pz4bb1x 2> /dev/null) 
# [[ "$ZABBIXHOST" ]] && HOST=$ZABBIXHOST

# declare an array with the TRAP text descriptions - RipEX
declare -A oid2desc

# RipEX
oid2desc[33555.2.10.1]="RipEX::trpRss - Remote station RSS value out of range"
oid2desc[33555.2.10.2]="RipEX::trpDq - Remote station DQ value out of range"
oid2desc[33555.2.10.5]="RipEX::trpTxLost - TX Lost value out of range"
oid2desc[33555.2.10.6]="RipEX::trpUcc - UCC value out of range"
oid2desc[33555.2.10.7]="RipEX::trpTemp - Modem temperature value out of range"
oid2desc[33555.2.10.8]="RipEX::trpRfpwr - RF power value out of range"
oid2desc[33555.2.10.9]="RipEX::trpVswr - VSWR value out of range"
oid2desc[33555.2.10.10]="RipEX::trpEthPr - Ethernet Rx/Tx packet ratio out of range"
oid2desc[33555.2.10.11]="RipEX::trpCom1Pr - COM1 Rx/Tx packet ratio out of range"
oid2desc[33555.2.10.12]="RipEX::trpCom2Pr - COM2 Rx/Tx packet ratio out of range"
oid2desc[33555.2.10.13]="RipEX::trpHwIn - HW input in the alarm state"
oid2desc[33555.2.10.14]="RipEX::trpHotStby - Modem becomes active in a Hot-Standby mode"
oid2desc[33555.2.10.15]="RipEX::trpBpath - Backup path state has been changed"
oid2desc[33555.2.10.16]="RipEX::trpBpathAlt - Alternative path state has been changed"
oid2desc[33555.2.10.17]="RipEX::trpUnitReady - Unit ready signal has changed"
oid2desc[33555.2.10.18]="RipEX::trpNomadOffline - Nomadic remote device is offline"

# 2020-08 RipEX2
oid2desc[33555.3.0.1]="RipEX2::sysBootFinishedNotif - System boot completed"
oid2desc[33555.3.0.5]="RipEX2::sysUsbFlashDiscNotif - USB flash disc plugged"
# sysTamperNotif replaced (obsolete since 1.4.8.0)
oid2desc[33555.3.0.6]="RipEX2::sysTamperNotif - Tamper open detected"
oid2desc[33555.3.0.7]="RipEX2::sysRtcBatteryLowNotif - RTC battery low"
oid2desc[33555.3.0.8]="RipEX2::sfpOvercurrentNotif - SFP overcurrent"
oid2desc[33555.3.0.9]="RipEX2::sfpFaultNotif - SFP fault"
oid2desc[33555.3.0.10]="RipEX2::usbOvercurrentNotif - USB overcurrent"
oid2desc[33555.3.0.11]="RipEX2::monCongestionNotif - Monitoring congestion"
# usbTtyAttachedNotif (obsolete since 1.4.8.0)
oid2desc[33555.3.0.12]="RipEX2::usbTtyAttachedNotif - USB serial converter plugged in"
oid2desc[33555.3.0.13]="RipEX2::svcAccessNotif - Service access plugged"
oid2desc[33555.3.0.14]="RipEX2::sysApiLoginNotif - Web interface login"
oid2desc[33555.3.0.15]="RipEX2::sysApiLoginFailNotif - Web interface login rejected"
oid2desc[33555.3.0.17]="RipEX2::radioKeyingStartedNotif - Radio keying started"
oid2desc[33555.3.0.21]="RipEX2::cnfUpdateNotif - Unit configuration changed"
oid2desc[33555.3.0.22]="RipEX2::accessPasswordChangedNotif - User password changed"
oid2desc[33555.3.0.24]="RipEX2::systemFwUpgradeNotif - Firmware upgrade performed"
oid2desc[33555.3.0.26]="RipEX2::alarmInputNotif - Alarm input"
oid2desc[33555.3.0.27]="RipEX2::timeSetNotif - Time set"
oid2desc[33555.3.0.28]="RipEX2::hstdbyActivateNotif - Hot standby activated"
oid2desc[33555.3.0.29]="RipEX2::hstdbyPassivateNotif - Hot standby passivated"
oid2desc[33555.3.0.30]="RipEX2::hstdbyCtrlErrorNotif - Hot standby controller failure"
oid2desc[33555.3.0.31]="RipEX2::accessApiAuthConnNotif - Cannot connect to authentication server"
oid2desc[33555.3.0.32]="RipEX2::accessApiAuthReplyNotif - Malformed reply from authentication server"
oid2desc[33555.3.0.33]="RipEX2::accessUserCreatedNotif - New user created"
oid2desc[33555.3.0.34]="RipEX2::accessUserDeletedNotif - User deleted"
oid2desc[33555.3.0.35]="RipEX2::accessUserUpdatedNotif - User updated"
oid2desc[33555.3.0.36]="RipEX2::accessUserRestoredNotif - User accounts were restored from backup"
oid2desc[33555.3.0.37]="RipEX2::radioTxAntennaProblemNotif - Radio TX or Antenna degradation - detected"
oid2desc[33555.3.0.38]="RipEX2::sfpNotPresentNotif - SFP not present"
oid2desc[33555.3.0.39]="RipEX2::eth1LinkDownNotif ETH1 link down"
oid2desc[33555.3.0.40]="RipEX2::eth2LinkDownNotif ETH2 link down"
oid2desc[33555.3.0.41]="RipEX2::eth3LinkDownNotif ETH3 link down"
oid2desc[33555.3.0.42]="RipEX2::eth4LinkDownNotif ETH4 link down"
oid2desc[33555.3.0.43]="RipEX2::eth5LinkDownNotif ETH5 link down"
oid2desc[33555.3.0.44]="RipEX2::sysTamperContactsNotif - Tamper contacts active"
oid2desc[33555.3.0.45]="RipEX2::di1Notif - DIO Input 1"
oid2desc[33555.3.0.46]="RipEX2::di2Notif - DIO Input 2"
oid2desc[33555.3.0.47]="RipEX2::di3Notif - DIO Input 3"
oid2desc[33555.3.0.48]="RipEX2::radioTemperatureLowNotif - Radio temperature too low"
oid2desc[33555.3.0.49]="RipEX2::radioTemperatureHighNotif - Radio temperature too high"
oid2desc[33555.3.0.50]="RipEX2::radioInternalFaultNotif - Radio internal fault"
oid2desc[33555.3.0.51]="RipEX2::modemTemperatureLowNotif - Modem temperature too low"
oid2desc[33555.3.0.52]="RipEX2::modemTemperatureHighNotif - Modem temperature too high"
oid2desc[33555.3.0.53]="RipEX2::cpuTemperatureLowNotif - CPU temperature too low"
oid2desc[33555.3.0.54]="RipEX2::cpuTemperatureHighNotif - CPU temperature too high"
oid2desc[33555.3.0.55]="RipEX2::inputVoltageLowNotif - Input voltage too low"
oid2desc[33555.3.0.56]="RipEX2::inputVoltageHighNotif - Input voltage too high"
oid2desc[33555.3.0.57]="RipEX2::radioBlockedTempNotif - Radio blocked due to temperature limit"
oid2desc[33555.3.0.58]="RipEX2::smsAlarmNotif - Alarm from SMS command"
oid2desc[33555.3.0.59]="RipEX2::sysFwUploadedNotif - System FW package uploaded"
oid2desc[33555.3.0.60]="RipEX2::sysFwUploadRejectedNotif - System FW package upload rejected"
oid2desc[33555.3.0.61]="RipEX2::sysFwUploadUnusableNotif - System FW package upload locally unusable"
oid2desc[33555.3.0.62]="RipEX2::fdistrSendingStartedNotif - File distribution was started"
oid2desc[33555.3.0.63]="RipEX2::fdistrSendingDoneNotif - File distribution was completed"
oid2desc[33555.3.0.64]="RipEX2::fdistrSendingStoppedNotif - File distribution was stopped"
oid2desc[33555.3.0.68]="RipEX2::cellMainDownNotif - Cellular MAIN link down"
oid2desc[33555.3.0.69]="RipEX2::cellExtDownNotif - Cellular EXT link down"
oid2desc[33555.3.0.71]="RipEX2::gnssPositionLostNotif - GNSS position lost"
oid2desc[33555.3.0.72]="RipEX2::gnssPpsSignalLostNotif - GNSS PPS signal lost"
oid2desc[33555.3.0.74]="RipEX2::ppp1LinkDownNotif - PPP1 link down"
oid2desc[33555.3.0.75]="RipEX2::ppp2LinkDownNotif - PPP2 link down"
oid2desc[33555.3.0.76]="RipEX2::ppp3LinkDownNotif - PPP3 link down"
oid2desc[33555.3.0.77]="RipEX2::cnfCheckWarningNotif - Configuration processing reports warnings"
oid2desc[33555.3.0.79]="RipEX2::credentialsUpdateNotif - Credentials contents changed"
oid2desc[33555.3.0.80]="RipEX2::credentialsDefChangeNotif - Default key in the credentials has changed"
oid2desc[33555.3.0.81]="RipEX2::linkMngNoLinkNotif - Link manager: No usable link"
oid2desc[33555.3.0.82]="RipEX2::linkMngLinkSwitchNotif - Link manager: Active link switched"
oid2desc[33555.3.0.83]="RipEX2::linkMngPrimaryDownNotif - Link manager: Primary link down"
oid2desc[33555.3.0.84]="RipEX2::openVpnClientConnectNotif - OpenVPN server is connected to client"
oid2desc[33555.3.0.85]="RipEX2::openVpnClientDisconnectNotif - OpenVPN server is disconnected from client"
oid2desc[33555.3.0.86]="RipEX2::openVpnConnectionDown1Notif - OpenVPN client 1 is not connected to server"
oid2desc[33555.3.0.87]="RipEX2::openVpnConnectionDown2Notif - OpenVPN client 2 is not connected to server"
oid2desc[33555.3.0.88]="RipEX2::openVpnConnectionDown3Notif - OpenVPN client 3 is not connected to server"
oid2desc[33555.3.0.89]="RipEX2::openVpnConnectionDown4Notif - OpenVPN client 4 is not connected to server"
oid2desc[33555.3.0.90]="RipEX2::pppoeClientLinkDownNotif - PPPoE client link down"
oid2desc[33555.3.0.92]="RipEX2::cnfBootErrorNotif - Boot configuration error"
oid2desc[33555.3.0.93]="RipEX2::wifiExtApClientConnectNotif - Wi-Fi EXT AP reports client connected"
oid2desc[33555.3.0.94]="RipEX2::wifiExtApClientDisconnectNotif - Wi-Fi EXT AP reports client disconnected"
oid2desc[33555.3.0.95]="RipEX2::testEvtNotif - Test event"
oid2desc[1.1.5.1]="ColdStart"
oid2desc[8072.4.0.2]="nsNotifyShutdown"

# M!DGE, MG102i
oid2desc[33555.10.100.0.1.0.1]="SDK trap"
oid2desc[33555.10.100.0.10.0.10]="MG::system-shutdown - Indicates a system shutdown"
oid2desc[33555.10.100.0.20.0.20]="MG::vpn-down-trap - Indicates a VPN connection deactivation"
oid2desc[33555.10.100.0.21.0.21]="MG::vpn-up-trap - Indicates a VPN connection activation"
oid2desc[33555.10.100.0.30.0.30]="MG::wwan-rssi-low - The WWAN RSSI is below the specified threshold"
oid2desc[33555.10.100.0.101.0.101]="MG::WAN link came UP"
oid2desc[33555.10.100.0.102.0.102]="MG::WAN link went DOWN"
oid2desc[33555.10.100.0.201.0.201]="MG::DIO IN1 turned ON"
oid2desc[33555.10.100.0.202.0.202]="MG::DIO IN1 turned OFF"
oid2desc[33555.10.100.0.203.0.203]="MG::DIO IN2 turned ON"
oid2desc[33555.10.100.0.204.0.204]="MG::DIO IN2 turned OFF"
oid2desc[33555.10.100.0.205.0.205]="MG::DIO OUT1 turned ON"
oid2desc[33555.10.100.0.206.0.206]="MG::DIO OUT1 turned OFF"
oid2desc[33555.10.100.0.207.0.207]="MG::DIO OUT2 turned ON"
oid2desc[33555.10.100.0.208.0.208]="MG::DIO OUT2 turned OFF"
oid2desc[33555.10.100.0.301.0.301]="MG::GPS signal is available"
oid2desc[33555.10.100.0.302.0.302]="MG::GPS signal is NOT available"
oid2desc[33555.10.100.0.401.0.401]="MG::OpenVPN connection came UP"
oid2desc[33555.10.100.0.402.0.402]="MG::OpenVPN connection went DOWN"
oid2desc[33555.10.100.0.403.0.403]="MG::IPsec connection came UP"
oid2desc[33555.10.100.0.404.0.404]="MG::IPsec connection went DOWN"
oid2desc[33555.10.100.0.406.0.406]="MG::PPTP connection came UP"
oid2desc[33555.10.100.0.407.0.407]="MG::PPTP connection went DOWN"
oid2desc[33555.10.100.0.408.0.408]="MG::Dial-In connection came UP"
oid2desc[33555.10.100.0.409.0.409]="MG::Dial-In connection went DOWN"
oid2desc[33555.10.100.0.410.0.410]="MG::Mobile IP connection came UP"
oid2desc[33555.10.100.0.411.0.411]="MG::Mobile IP conneciton went DOWN"
oid2desc[33555.10.100.0.412.0.412]="MG::GRE connection came UP"
oid2desc[33555.10.100.0.413.0.413]="MG::GRE connection went DOWN"
oid2desc[33555.10.100.0.501.0.501]="MG::User login failed"
# oid2desc[33555.10.100.0.502.0.502]="MG::User login succeeded"
# oid2desc[33555.10.100.0.503.0.503]="MG::User logged out"
oid2desc[33555.10.100.0.504.0.504]="MG::System reboot has been triggered"
oid2desc[33555.10.100.0.505.0.505]="MG::System has been started"
oid2desc[33555.10.100.0.506.0.506]="MG::test event"
# oid2desc[33555.10.100.0.507.0.507]="MG::SDK has started"
# oid2desc[33555.10.100.0.508.0.508]="MG::System time has been updated"
oid2desc[33555.10.100.0.509.0.509]="MG::System poweroff has been triggered"
#oid2desc[33555.10.100.0.601.0.601]="MG::SMS has been sent"
#oid2desc[33555.10.100.0.602.0.602]="MG::SMS has not been sent"
oid2desc[33555.10.100.0.603.0.603]="MG::SMS has been received"
#oid2desc[33555.10.100.0.604.0.604]="MG::SMS report has been received"
#oid2desc[33555.10.100.0.701.0.701]="MG::A voice call is coming in"
#oid2desc[33555.10.100.0.702.0.702]="MG::Outgoing voice call is being established"
#oid2desc[33555.10.100.0.802.0.801]="MG::Dynamic DNS update succeeded"
oid2desc[33555.10.100.0.802.0.802]="MG::Dynamic DNS update failed"
#oid2desc[33555.10.100.0.901.0.901]="MG::USB storage device has been added"
#oid2desc[33555.10.100.0.902.0.902]="MG::USB storage device has been removed"
#oid2desc[33555.10.100.0.903.0.903]="MG::USB Ethernet device has been added"
#oid2desc[33555.10.100.0.904.0.904]="MG::USB Ethernet device has been removed"
#oid2desc[33555.10.100.0.905.0.905]="MG::USB serial device has been added"
#oid2desc[33555.10.100.0.906.0.906]="MG::USB serial device has ben removed"
#oid2desc[33555.10.100.0.1001.0.1001]="MG::System is now master router"
#oid2desc[33555.10.100.0.1002.0.1002]="MG::System is now backup router"

# M!DGE2, 2020-07-14
oid2desc[33555.10.100.0.1]="MG::SDK trap"
oid2desc[33555.10.100.0.10]="MG::system-shutdown - Indicates a system shutdown"
oid2desc[33555.10.100.0.20]="MG::vpn-down-trap - Indicates a VPN connection deactivation"
oid2desc[33555.10.100.0.21]="MG::vpn-up-trap - Indicates a VPN connection activation"
oid2desc[33555.10.100.0.30]="MG::wwan-rssi-low - The WWAN RSSI is below the specified threshold"
oid2desc[33555.10.100.0.101]="MG::WAN link came UP"
oid2desc[33555.10.100.0.102]="MG::WAN link went DOWN"
oid2desc[33555.10.100.0.201]="MG::DIO IN1 turned ON"
oid2desc[33555.10.100.0.202]="MG::DIO IN1 turned OFF"
oid2desc[33555.10.100.0.203]="MG::DIO IN2 turned ON"
oid2desc[33555.10.100.0.204]="MG::DIO IN2 turned OFF"
oid2desc[33555.10.100.0.205]="MG::DIO OUT1 turned ON"
oid2desc[33555.10.100.0.206]="MG::DIO OUT1 turned OFF"
oid2desc[33555.10.100.0.207]="MG::DIO OUT2 turned ON"
oid2desc[33555.10.100.0.208]="MG::DIO OUT2 turned OFF"
oid2desc[33555.10.100.0.301]="MG::GPS signal is available"
oid2desc[33555.10.100.0.302]="MG::GPS signal is NOT available"
oid2desc[33555.10.100.0.401]="MG::OpenVPN connection came UP"
oid2desc[33555.10.100.0.402]="MG::OpenVPN connection went DOWN"
oid2desc[33555.10.100.0.403]="MG::IPsec connection came UP"
oid2desc[33555.10.100.0.404]="MG::IPsec connection went DOWN"
oid2desc[33555.10.100.0.406]="MG::PPTP connection came UP"
oid2desc[33555.10.100.0.407]="MG::PPTP connection went DOWN"
oid2desc[33555.10.100.0.408]="MG::Dial-In connection came UP"
oid2desc[33555.10.100.0.409]="MG::Dial-In connection went DOWN"
oid2desc[33555.10.100.0.410]="MG::Mobile IP connection came UP"
oid2desc[33555.10.100.0.411]="MG::Mobile IP conneciton went DOWN"
oid2desc[33555.10.100.0.412]="MG::GRE connection came UP"
oid2desc[33555.10.100.0.413]="MG::GRE connection went DOWN"
oid2desc[33555.10.100.0.501]="MG::User login failed"
# oid2desc[33555.10.100.0.502]="MG::User login succeeded"
# oid2desc[33555.10.100.0.503]="MG::User logged out"
oid2desc[33555.10.100.0.504]="MG::System reboot has been triggered"
oid2desc[33555.10.100.0.505]="MG::System has been started"
oid2desc[33555.10.100.0.506]="MG::test event"
# oid2desc[33555.10.100.0.507]="MG::SDK has started"
# oid2desc[33555.10.100.0.508]="MG::System time has been updated"
oid2desc[33555.10.100.0.509]="MG::System poweroff has been triggered"
#oid2desc[33555.10.100.0.601]="MG::SMS has been sent"
#oid2desc[33555.10.100.0.602]="MG::SMS has not been sent"
oid2desc[33555.10.100.0.603]="MG::SMS has been received"
#oid2desc[33555.10.100.0.604]="MG::SMS report has been received"
#oid2desc[33555.10.100.0.701]="MG::A voice call is coming in"
#oid2desc[33555.10.100.0.702]="MG::Outgoing voice call is being established"
#oid2desc[33555.10.100.0.802]="MG::Dynamic DNS update succeeded"
oid2desc[33555.10.100.0.802]="MG::Dynamic DNS update failed"
#oid2desc[33555.10.100.0.901]="MG::USB storage device has been added"
#oid2desc[33555.10.100.0.902]="MG::USB storage device has been removed"
#oid2desc[33555.10.100.0.903]="MG::USB Ethernet device has been added"
#oid2desc[33555.10.100.0.904]="MG::USB Ethernet device has been removed"
#oid2desc[33555.10.100.0.905]="MG::USB serial device has been added"
#oid2desc[33555.10.100.0.906]="MG::USB serial device has ben removed"
#oid2desc[33555.10.100.0.1001]="MG::System is now master router"
#oid2desc[33555.10.100.0.1002]="MG::System is now backup router"

# RAy1-10 
oid2desc[33555.1.10.0.1]="RacomRay::airDisconnect - Air line disconnected"
oid2desc[33555.1.10.0.2]="RacomRay::airConnect - Air line connected after being disconnected"
oid2desc[33555.1.10.0.3]="RacomRay::airWdog - Air watch dog"
oid2desc[33555.1.10.0.4]="RacomRay::tempAlarm - Temperature exceeded the threshold"
oid2desc[33555.1.10.0.5]="RacomRay::powerAlarm - Power voltage is out of thresholds"
oid2desc[33555.1.10.0.6]="RacomRay::memoryAlarm - Memory use exceeded the threshold"
oid2desc[33555.1.10.0.7]="RacomRay::rssAlarm - RSS exceeded the threshold"
oid2desc[33555.1.10.0.8]="RacomRay::snrAlarm - SNR exceeded the threshold"
oid2desc[33555.1.10.0.9]="RacomRay::berAlarm - BER exceeded the threshold"
oid2desc[33555.1.10.0.10]="RacomRay::rfPowerFail - RF Power amplifier failure"
oid2desc[33555.1.10.0.11]="RacomRay::peerEthLinkDown - Peer station ethernet link Up/Down"

# RAy1-11,17,24
oid2desc[33555.1.10.1]="RacomRay::airDisconnect - Air line disconnected"
oid2desc[33555.1.10.2]="RacomRay::airConnect - Air line connected after being disconnected"
oid2desc[33555.1.10.3]="RacomRay::airWdog - Air watch dog"
oid2desc[33555.1.10.4]="RacomRay::tempAlarm - Temperature exceeded the threshold"
oid2desc[33555.1.10.5]="RacomRay::powerAlarm - Power voltage is out of thresholds"
oid2desc[33555.1.10.6]="RacomRay::memoryAlarm - Memory use exceeded the threshold"
oid2desc[33555.1.10.7]="RacomRay::rssAlarm - RSS exceeded the threshold"
oid2desc[33555.1.10.8]="RacomRay::snrAlarm - SNR exceeded the threshold"
oid2desc[33555.1.10.9]="RacomRay::berAlarm - BER exceeded the threshold"
oid2desc[33555.1.10.10]="RacomRay::rfPowerFail - RF Power amplifier failure"
oid2desc[33555.1.10.11]="RacomRay::peerEthLinkDown - Peer station ethernet link Up/Down"

# RAy2, two different versions
oid2desc[33555.1.11.1]="RacomRay::tr2TemperatureAlarm - Temperature exceeded the threshold"
oid2desc[33555.1.11.2]="RacomRay::tr2VoltageLowAlarm - Supply voltage below minimal threshold"
oid2desc[33555.1.11.3]="RacomRay::tr2VoltageHighAlarm - Supply voltage above maximal threshold"
oid2desc[33555.1.11.4]="RacomRay::tr2RssAlarm - RSS exceeded the threshold"
oid2desc[33555.1.11.5]="RacomRay::tr2SnrAlarm - SNR exceeded the threshold"
oid2desc[33555.1.11.6]="RacomRay::tr2BerAlarm - BER exceeded the threshold"
oid2desc[33555.1.11.7]="RacomRay::tr2AirConnectDisconnect - Air line disconnected"
oid2desc[33555.1.11.8]="RacomRay::tr2AirConnectDisconnect - Air line disconnected"
oid2desc[33555.1.11.9]="RacomRay::tr2Eth1LinkDown - Peer station Ethernet 1 link Up/Down"
oid2desc[33555.1.11.10]="RacomRay::tr2Eth2LinkDown - Peer station Ethernet 2 link Up/Down"
oid2desc[33555.1.11.11]="RacomRay::tr2RfPowerFail - RF Power amplifier failure"
oid2desc[33555.1.11.12]="RacomRay::tr2NetBitrate - Air speed below threshold"
oid2desc[33555.1.11.13]="RacomRay::tr2WifiOn - WiFi Host Access Point is on"

oid2desc[33555.1.11.0.1]="RacomRay::tr2TemperatureAlarm - Temperature exceeded the threshold"
oid2desc[33555.1.11.0.2]="RacomRay::tr2VoltageLowAlarm - Supply voltage below minimal threshold"
oid2desc[33555.1.11.0.3]="RacomRay::tr2VoltageHighAlarm - Supply voltage above maximal threshold"
oid2desc[33555.1.11.0.4]="RacomRay::tr2RssAlarm - RSS exceeded the threshold"
oid2desc[33555.1.11.0.5]="RacomRay::tr2SnrAlarm - SNR exceeded the threshold"
oid2desc[33555.1.11.0.6]="RacomRay::tr2BerAlarm - BER exceeded the threshold"
oid2desc[33555.1.11.0.7]="RacomRay::tr2AirConnectDisconnect - Air line disconnected"
oid2desc[33555.1.11.0.8]="RacomRay::tr2AirConnectDisconnect - Air line disconnected"
oid2desc[33555.1.11.0.9]="RacomRay::tr2Eth1LinkDown - Peer station Ethernet 1 link Up/Down"
oid2desc[33555.1.11.0.10]="RacomRay::tr2Eth2LinkDown - Peer station Ethernet 2 link Up/Down"
oid2desc[33555.1.11.0.11]="RacomRay::tr2RfPowerFail - RF Power amplifier failure"
oid2desc[33555.1.11.0.12]="RacomRay::tr2NetBitrate - Air speed below threshold"
oid2desc[33555.1.11.0.13]="RacomRay::tr2WifiOn - WiFi Host Access Point is on"
oid2desc[33555.1.11.0.101]="RacomRay::tr2AirCapacity - Air Capacity changed"

# RAy3 FW 1.0.14.0 and older
oid2desc[33555.1.12.0.1]="RacomRay::tr3TemperatureAlarm - Temperature exceeded the threshold"
oid2desc[33555.1.12.0.2]="RacomRay::tr3VoltageLowAlarm - Supply voltage below minimal threshold"
oid2desc[33555.1.12.0.3]="RacomRay::tr3VoltageHighAlarm - Supply voltage above maximal threshold"
oid2desc[33555.1.12.0.4]="RacomRay::tr3RssAlarm - RSS exceeded the threshold"
oid2desc[33555.1.12.0.5]="RacomRay::tr3MseAlarm - MSE exceeded the threshold"
oid2desc[33555.1.12.0.6]="RacomRay::tr3BerAlarm - BER exceeded the threshold"
oid2desc[33555.1.12.0.7]="RacomRay::tr3AirConnectDisconnect - Air line disconnected"
oid2desc[33555.1.12.0.8]="RacomRay::tr3AirConnectDisconnect - Air line disconnected"
oid2desc[33555.1.12.0.9]="RacomRay::tr3Eth1LinkDown - Peer station Ethernet 1 link Up/Down"
oid2desc[33555.1.12.0.10]="RacomRay::tr3Eth2LinkDown - Peer station Ethernet 2 link Up/Down"
oid2desc[33555.1.12.0.11]="RacomRay::tr3NetBitrate - Air speed below threshold"
oid2desc[33555.1.12.0.12]="RacomRay::tr3WifiOn - WiFi Host Access Point is on"
oid2desc[33555.1.12.0.101]="RacomRay::tr3EventAirCapacity - Air channel capacity changed"

# RAy3 FW 1.0.15.0 and newer
oid2desc[33555.4.12.0.1]="RacomRay::tr3TemperatureAlarm - Temperature exceeded the threshold"
oid2desc[33555.4.12.0.2]="RacomRay::tr3VoltageLowAlarm - Supply voltage below minimal threshold"
oid2desc[33555.4.12.0.3]="RacomRay::tr3VoltageHighAlarm - Supply voltage above maximal threshold"
oid2desc[33555.4.12.0.4]="RacomRay::tr3RssAlarm - RSS exceeded the threshold"
oid2desc[33555.4.12.0.5]="RacomRay::tr3MseAlarm - MSE exceeded the threshold"
oid2desc[33555.4.12.0.6]="RacomRay::tr3BerAlarm - BER exceeded the threshold"
oid2desc[33555.4.12.0.7]="RacomRay::tr3AirConnectDisconnect - Air line disconnected"
oid2desc[33555.4.12.0.8]="RacomRay::tr3AirConnectDisconnect - Air line disconnected"
oid2desc[33555.4.12.0.9]="RacomRay::tr3Eth1LinkDown - Peer station Ethernet 1 link Up/Down"
oid2desc[33555.4.12.0.10]="RacomRay::tr3Eth2LinkDown - Peer station Ethernet 2 link Up/Down"
oid2desc[33555.4.12.0.11]="RacomRay::tr3NetBitrate - Air speed below threshold"
oid2desc[33555.4.12.0.12]="RacomRay::tr3WifiOn - WiFi Host Access Point is on"
oid2desc[33555.4.12.0.13]="RacomRay::tr3SupplyOutOfRange - Power supply voltage is out of range"
oid2desc[33555.4.12.0.14]="RacomRay::tr3TxMute - Transmitter was muted"
oid2desc[33555.4.12.0.101]="RacomRay::tr3EventAirCapacity - Air channel capacity changed"
oid2desc[33555.4.12.0.102]="RacomRay::tr3EventLspActivated - Link State Propagation activated"

# set the right KEY parameter
case $racomTrapOid in
        33555.2.10.1) KEY="trpRss";;
        33555.2.10.2) KEY="trpDq";;
        33555.2.10.5) KEY="trpTxLost";;
        33555.2.10.6) KEY="trpUcc";;
        33555.2.10.7) KEY="trpTemp";;
        33555.2.10.8) KEY="trpRfpwr";;
        33555.2.10.9) KEY="trpVswr";;
        33555.2.10.10) KEY="trpEthPr";;
        33555.2.10.11) KEY="trpCom1Pr";;
        33555.2.10.12) KEY="trpCom2Pr";;
        33555.2.10.13) KEY="trpHwIn";;
        33555.2.10.14) KEY="trpHotStby";;
	33555.2.10.15) KEY="trpBpath";;
	33555.2.10.16) KEY="trpBpathAlt";;
	33555.2.10.17) KEY="trpUnitReady";;
	33555.2.10.18) KEY="trpNomadOffline";;
	33555.3.0.1) KEY="sysBootFinishedNotif";;
	33555.3.0.5) KEY="sysUsbFlashDiscNotif";;
	33555.3.0.6) KEY="sysTamperNotif";;
	33555.3.0.7) KEY="sysRtcBatteryLowNotif";;
	33555.3.0.8) KEY="sfpOvercurrentNotif";;
	33555.3.0.9) KEY="sfpFaultNotif";;
	33555.3.0.10) KEY="usbOvercurrentNotif";;
	33555.3.0.11) KEY="monCongestionNotif";;
	33555.3.0.12) KEY="usbTtyAttachedNotif";;
	33555.3.0.13) KEY="svcAccessNotif";;
	33555.3.0.14) KEY="sysApiLoginNotif";;
	33555.3.0.15) KEY="sysApiLoginFailNotif";;
	33555.3.0.17) KEY="radioKeyingStartedNotif";;
	33555.3.0.21) KEY="cnfUpdateNotif";;
	33555.3.0.22) KEY="accessPasswordChangedNotif";;
	33555.3.0.24) KEY="systemFwUpgradeNotif";;
	33555.3.0.26) KEY="alarmInputNotif";;
	33555.3.0.27) KEY="timeSetNotif";;
	33555.3.0.28) KEY="hstdbyActivateNotif";;
	33555.3.0.29) KEY="hstdbyPassivateNotif";;
	33555.3.0.30) KEY="hstdbyCtrlErrorNotif";;
	33555.3.0.31) KEY="accessApiAuthConnNotif";;
	33555.3.0.32) KEY="accessApiAuthReplyNotif";;
	33555.3.0.33) KEY="accessUserCreatedNotif";;
	33555.3.0.34) KEY="accessUserDeletedNotif";;
	33555.3.0.35) KEY="accessUserUpdatedNotif";;
	33555.3.0.36) KEY="accessUserRestoredNotif";;
	33555.3.0.37) KEY="radioTxAntennaProblemNotif";;
	33555.3.0.38) KEY="sfpNotPresentNotif";;
	33555.3.0.39) KEY="eth1LinkDownNotif";;
	33555.3.0.40) KEY="eth2LinkDownNotif";;
	33555.3.0.41) KEY="eth3LinkDownNotif";;
	33555.3.0.42) KEY="eth4LinkDownNotif";;
	33555.3.0.43) KEY="eth5LinkDownNotif";;
	33555.3.0.44) KEY="sysTamperContactsNotif";;
	33555.3.0.45) KEY="di1Notif";;
	33555.3.0.46) KEY="di2Notif";;
	33555.3.0.47) KEY="di3Notif";;
	33555.3.0.48) KEY="radioTemperatureLowNotif";;	
	33555.3.0.49) KEY="radioTemperatureHighNotif";;
	33555.3.0.50) KEY="radioInternalFaultNotif";;
	33555.3.0.51) KEY="modemTemperatureLowNotif";;
	33555.3.0.52) KEY="modemTemperatureHighNotif";;
	33555.3.0.53) KEY="cpuTemperatureLowNotif";;
	33555.3.0.54) KEY="cpuTemperatureHighNotif";;
	33555.3.0.55) KEY="inputVoltageLowNotif";;
	33555.3.0.56) KEY="inputVoltageHighNotif";;
	33555.3.0.57) KEY="radioBlockedTempNotif";;
        33555.3.0.58) KEY="smsAlarmNotif";;
        33555.3.0.59) KEY="sysFwUploadedNotif";;
        33555.3.0.60) KEY="sysFwUploadRejectedNotif";;
        33555.3.0.61) KEY="sysFwUploadUnusableNotif";;
        33555.3.0.62) KEY="fdistrSendingStartedNotif";;
        33555.3.0.63) KEY="fdistrSendingDoneNotif";;
        33555.3.0.64) KEY="fdistrSendingStoppedNotif";;	
	33555.3.0.68) KEY="cellMainDownNotif";;
	33555.3.0.69) KEY="cellExtDownNotif";;
	33555.3.0.71) KEY="gnssPositionLostNotif";;
	33555.3.0.72) KEY="gnssPpsSignalLostNotif";;
	33555.3.0.74) KEY="ppp1LinkDownNotif";;
	33555.3.0.75) KEY="ppp2LinkDownNotif";;
	33555.3.0.76) KEY="ppp3LinkDownNotif";;
	33555.3.0.77) KEY="cnfCheckWarningNotif";;
	33555.3.0.79) KEY="credentialsUpdateNotif";;
	33555.3.0.80) KEY="credentialsDefChangeNotif";;
	33555.3.0.81) KEY="linkMngNoLinkNotif";;
	33555.3.0.82) KEY="linkMngLinkSwitchNotif";;
	33555.3.0.83) KEY="linkMngPrimaryDownNotif";;
	33555.3.0.84) KEY="openVpnClientConnectNotif";;
        33555.3.0.85) KEY="openVpnClientDisconnectNotif";;
        33555.3.0.86) KEY="openVpnConnectionDown1Notif";;
        33555.3.0.87) KEY="openVpnConnectionDown2Notif";;
        33555.3.0.88) KEY="openVpnConnectionDown3Notif";;
        33555.3.0.89) KEY="openVpnConnectionDown4Notif";;
	33555.3.0.90) KEY="pppoeClientLinkDownNotif";;
	33555.3.0.92) KEY="cnfBootErrorNotif";;
	33555.3.0.93) KEY="wifiExtApClientConnectNotif";;
	33555.3.0.94) KEY="wifiExtApClientDisconnectNotif";;
	33555.3.0.95) KEY="testEvtNotif";;
	1.1.5.1) KEY="coldStart";;
	8072.4.0.2) KEY="nsNotifyShutdown";;
	33555.10.100.0.1.0.1) KEY="trpSdk";;
	33555.10.100.0.10.0.10) KEY="trpMgShut";;
	33555.10.100.0.20.0.20) KEY="trpMgVpn";;
	33555.10.100.0.21.0.21) KEY="trpMgVpn";;
	33555.10.100.0.30.0.30) KEY="trpMgRssi";;
	33555.10.100.0.101.0.101) KEY="wanLinkDown";;
	33555.10.100.0.102.0.102) KEY="wanLinkDown";;
	33555.10.100.0.201.0.201) KEY="dioIn1";;
	33555.10.100.0.202.0.202) KEY="dioIn1";;
	33555.10.100.0.203.0.203) KEY="dioIn2";;
	33555.10.100.0.204.0.204) KEY="dioIn2";;
	33555.10.100.0.205.0.205) KEY="dioOut1";;
	33555.10.100.0.206.0.206) KEY="dioOut1";;
	33555.10.100.0.207.0.207) KEY="dioOut2";;
	33555.10.100.0.208.0.208) KEY="dioOut2";;
	33555.10.100.0.301.0.301) KEY="gps";;
	33555.10.100.0.302.0.302) KEY="gps";;
	33555.10.100.0.401.0.401) KEY="openvpnDown";;
	33555.10.100.0.402.0.402) KEY="openvpnDown";;
	33555.10.100.0.403.0.403) KEY="ipsecDown";;
	33555.10.100.0.404.0.404) KEY="ipsecDown";;
	33555.10.100.0.406.0.406) KEY="pptpDown";;
	33555.10.100.0.407.0.407) KEY="pptpDown";;
	33555.10.100.0.408.0.408) KEY="dialinDown";;
	33555.10.100.0.409.0.409) KEY="dialinDown";;
	33555.10.100.0.410.0.410) KEY="mobileIpDown";;
	33555.10.100.0.411.0.411) KEY="mobileIpDown";;
	33555.10.100.0.412.0.412) KEY="greDown";;
	33555.10.100.0.413.0.413) KEY="greDown";;
	33555.10.100.0.501.0.501) KEY="userLoginFailed";;
	33555.10.100.0.504.0.504) KEY="reboot";;
	33555.10.100.0.505.0.505) KEY="systemStart";;
	33555.10.100.0.506.0.506) KEY="test";;
	33555.10.100.0.603.0.603) KEY="smsReceived";;
	33555.10.100.0.802.0.802) KEY="dyndnsFailed";;
	33555.10.100.0.1) KEY="trpSdk";;
	33555.10.100.0.10) KEY="trpMgShut";;
        33555.10.100.0.20) KEY="trpMgVpn";;
        33555.10.100.0.21) KEY="trpMgVpn";;
        33555.10.100.0.30) KEY="trpMgRssi";;
        33555.10.100.0.101) KEY="wanLinkDown";;
        33555.10.100.0.102) KEY="wanLinkDown";;
        33555.10.100.0.201) KEY="dioIn1";;
        33555.10.100.0.202) KEY="dioIn1";;
        33555.10.100.0.203) KEY="dioIn2";;
        33555.10.100.0.204) KEY="dioIn2";;
        33555.10.100.0.205) KEY="dioOut1";;
        33555.10.100.0.206) KEY="dioOut1";;
        33555.10.100.0.207) KEY="dioOut2";;
        33555.10.100.0.208) KEY="dioOut2";;
        33555.10.100.0.301) KEY="gps";;
        33555.10.100.0.302) KEY="gps";;
        33555.10.100.0.401) KEY="openvpnDown";;
        33555.10.100.0.402) KEY="openvpnDown";;
        33555.10.100.0.403) KEY="ipsecDown";;
        33555.10.100.0.404) KEY="ipsecDown";;
        33555.10.100.0.406) KEY="pptpDown";;
        33555.10.100.0.407) KEY="pptpDown";;
        33555.10.100.0.408) KEY="dialinDown";;
        33555.10.100.0.409) KEY="dialinDown";;
        33555.10.100.0.410) KEY="mobileIpDown";;
        33555.10.100.0.411) KEY="mobileIpDown";;
        33555.10.100.0.412) KEY="greDown";;
        33555.10.100.0.413) KEY="greDown";;
        33555.10.100.0.501) KEY="userLoginFailed";;
        33555.10.100.0.504) KEY="reboot";;
        33555.10.100.0.505) KEY="systemStart";;
        33555.10.100.0.506) KEY="test";;
        33555.10.100.0.603) KEY="smsReceived";;
        33555.10.100.0.802) KEY="dyndnsFailed";;
	33555.1.10.0.1) KEY="airDisconnect";;
        33555.1.10.0.2) KEY="airConnect";;
        33555.1.10.0.3) KEY="airWdog";;
        33555.1.10.0.4) KEY="tempAlarm";;
        33555.1.10.0.5) KEY="powerAlarm";;
        33555.1.10.0.6) KEY="memoryAlarm";;
        33555.1.10.0.7) KEY="rssAlarm";;
        33555.1.10.0.8) KEY="snrAlarm";;
        33555.1.10.0.9) KEY="berAlarm";;
        33555.1.10.0.10) KEY="rfPowerFail";;
        33555.1.10.0.11) KEY="peerEthLinkDown";;
        33555.1.10.1) KEY="airDisconnect";;
        33555.1.10.2) KEY="airConnect";;
        33555.1.10.3) KEY="airWdog";;
        33555.1.10.4) KEY="tempAlarm";;
        33555.1.10.5) KEY="powerAlarm";;
        33555.1.10.6) KEY="memoryAlarm";;
        33555.1.10.7) KEY="rssAlarm";;
        33555.1.10.8) KEY="snrAlarm";;
        33555.1.10.9) KEY="berAlarm";;
        33555.1.10.10) KEY="rfPowerFail";;
        33555.1.10.11) KEY="peerEthLinkDown";;
        33555.1.11.1) KEY="tr2TemperatureAlarm";;
        33555.1.11.2) KEY="tr2VoltageLowAlarm";;
        33555.1.11.3) KEY="tr2VoltageHighAlarm";;
        33555.1.11.4) KEY="tr2RssAlarm";;
        33555.1.11.5) KEY="tr2SnrAlarm";;
        33555.1.11.6) KEY="tr2BerAlarm";;
        33555.1.11.7) KEY="tr2AirDisconnect";;
        33555.1.11.8) KEY="tr2AirDisconnect";;
        33555.1.11.9) KEY="tr2Eth1LinkDown";;
        33555.1.11.10) KEY="tr2Eth2LinkDown";;
        33555.1.11.11) KEY="tr2RfPowerFail";;
 	33555.1.11.12) KEY="tr2NetBitrate";;
	33555.1.11.13) KEY="tr2WifiOn";;
        33555.1.11.0.1) KEY="tr2TemperatureAlarm";;
        33555.1.11.0.2) KEY="tr2VoltageLowAlarm";;
        33555.1.11.0.3) KEY="tr2VoltageHighAlarm";;
        33555.1.11.0.4) KEY="tr2RssAlarm";;
        33555.1.11.0.5) KEY="tr2SnrAlarm";;
        33555.1.11.0.6) KEY="tr2BerAlarm";;
        33555.1.11.0.7) KEY="tr2AirDisconnect";;
        33555.1.11.0.8) KEY="tr2AirDisconnect";;
        33555.1.11.0.9) KEY="tr2Eth1LinkDown";;
        33555.1.11.0.10) KEY="tr2Eth2LinkDown";;
        33555.1.11.0.11) KEY="tr2RfPowerFail";;
 	33555.1.11.0.12) KEY="tr2NetBitrate";;
	33555.1.11.0.13) KEY="tr2WifiOn";;
	33555.1.11.0.101) KEY="tr2AirCapacity";;
        33555.1.12.0.1) KEY="tr3TemperatureAlarm";;
        33555.1.12.0.2) KEY="tr3VoltageLowAlarm";;
        33555.1.12.0.3) KEY="tr3VoltageHighAlarm";;
        33555.1.12.0.4) KEY="tr3RssAlarm";;
        33555.1.12.0.5) KEY="tr3MseAlarm";;
        33555.1.12.0.6) KEY="tr3BerAlarm";;
        33555.1.12.0.7) KEY="tr3AirDisconnect";;
        33555.1.12.0.8) KEY="tr3AirDisconnect";;
        33555.1.12.0.9) KEY="tr3Eth1LinkDown";;
        33555.1.12.0.10) KEY="tr3Eth2LinkDown";;
 	33555.1.12.0.11) KEY="tr3NetBitrate";;
	33555.1.12.0.12) KEY="tr3WifiOn";;
	33555.1.12.0.101) KEY="tr3EventAirCapacity";;
        33555.4.12.0.1) KEY="tr3TemperatureAlarm";;
        33555.4.12.0.2) KEY="tr3VoltageLowAlarm";;
        33555.4.12.0.3) KEY="tr3VoltageHighAlarm";;
        33555.4.12.0.4) KEY="tr3RssAlarm";;
        33555.4.12.0.5) KEY="tr3MseAlarm";;
        33555.4.12.0.6) KEY="tr3BerAlarm";;
        33555.4.12.0.7) KEY="tr3AirDisconnect";;
        33555.4.12.0.8) KEY="tr3AirDisconnect";;
        33555.4.12.0.9) KEY="tr3Eth1LinkDown";;
        33555.4.12.0.10) KEY="tr3Eth2LinkDown";;
 	33555.4.12.0.11) KEY="tr3NetBitrate";;
	33555.4.12.0.12) KEY="tr3WifiOn";;
	33555.4.12.0.13) KEY="tr3SupplyOutOfRange";;
	33555.4.12.0.14) KEY="tr3TxMute";;
	33555.4.12.0.101) KEY="tr3EventAirCapacity";;
	33555.4.12.0.102) KEY="tr3EventLspActivated";;
        *) KEY="snmptraps";;
esac

# LOGGING TRAP INFO
echo "UPTIME: $uptime" >> ${LOGFILE}
echo "Host: $host, Key: $KEY" >> ${LOGFILE}
# echo "Number of vars: $NUMBER_OF_VARS"  >> ${LOGFILE}

# RipEX2 separate part
# else other products
if [[ "$racomTrapOid" == *33555.3.0* ]] || [[ "$racomTrapOid" == *1.1.5.1* ]] || [[ "$racomTrapOid" == *8072.4.0.2* ]]; then
	# RipEX2 section

	# Severity  
	# alarmValue - SEVERITY for each trap, 1st parameter
	value2severity[1]="emergency"
	value2severity[2]="alert"
	value2severity[3]="critical"
	value2severity[4]="error"
	value2severity[5]="warning"
	value2severity[6]="notice"
	value2severity[7]="informational"
	value2severity[8]="debug"

	# sysApiLoginGroup  .1.3.6.1.4.1.33555.3.5.14.4
	# accessUserCreatedGroup  .1.3.6.1.4.1.33555.3.5.33.4
	# accessUserDeletedGroup  .1.3.6.1.4.1.33555.3.5.34.4
	# accessUserUpdatedOldGroup  .1.3.6.1.4.1.33555.3.5.35.4
	# accessUserUpdatedNewGroup  .1.3.6.1.4.1.33555.3.5.35.5
	value2LoginGroup[1]="na"
	value2LoginGroup[1]="guest"
	value2LoginGroup[3]="tech"
	value2LoginGroup[4]="sectech"
	value2LoginGroup[5]="admin"

	# hstdbyActivateReason  .1.3.6.1.4.1.33555.3.5.28.3
	# hstdbyPassivateReason  .1.3.6.1.4.1.33555.3.5.29.3	
	value2hsReason[1]="na"
	value2hsReason[2]="manualSwitch"
	value2hsReason[3]="chanGranted"
	value2hsReason[4]="chanRequested"
	value2hsReason[5]="peerFailed"
	value2hsReason[6]="alarm"
	value2hsReason[7]="chanDenied"
	value2hsReason[8]="apiToggle"
	value2hsReason[9]="fallbackTimer"

	# sysBootFinishedReason  .1.3.6.1.4.1.33555.3.5.1.3
	value2bootReason[1]="unknown"
	value2bootReason[2]="standard"
	value2bootReason[3]="wdgUpgrade"
	value2bootReason[4]="recovery"

	# IF the trap is with STATUS information
	if [[ "$racomTrapOid" == *33555.3.0.5 ]] || [[ "$racomTrapOid" == *33555.3.0.6 ]] || [[ "$racomTrapOid" == *33555.3.0.7 ]] || [[ "$racomTrapOid" == *33555.3.0.8 ]] || [[ "$racomTrapOid" == *33555.3.0.9 ]] || [[ "$racomTrapOid" == *33555.3.0.10 ]] || [[ "$racomTrapOid" == *33555.3.0.11 ]] || [[ "$racomTrapOid" == *33555.3.0.12 ]] || [[ "$racomTrapOid" == *33555.3.0.13 ]] || [[ "$racomTrapOid" == *33555.3.0.14 ]] || [[ "$racomTrapOid" == *33555.3.0.26 ]] || [[ "$racomTrapOid" == *33555.3.0.30 ]] || [[ "$racomTrapOid" == *33555.3.0.37 ]] || [[ "$racomTrapOid" == *33555.3.0.38 ]] || [[ "$racomTrapOid" == *33555.3.0.39 ]] || [[ "$racomTrapOid" == *33555.3.0.40 ]] || [[ "$racomTrapOid" == *33555.3.0.41 ]] || [[ "$racomTrapOid" == *33555.3.0.42 ]] || [[ "$racomTrapOid" == *33555.3.0.43 ]] || [[ "$racomTrapOid" == *33555.3.0.44 ]] || [[ "$racomTrapOid" == *33555.3.0.45 ]] || [[ "$racomTrapOid" == *33555.3.0.46 ]] || [[ "$racomTrapOid" == *33555.3.0.47 ]] || [[ "$racomTrapOid" == *33555.3.0.48 ]] || [[ "$racomTrapOid" == *33555.3.0.49 ]] || [[ "$racomTrapOid" == *33555.3.0.50 ]] || [[ "$racomTrapOid" == *33555.3.0.51 ]] || [[ "$racomTrapOid" == *33555.3.0.52 ]] || [[ "$racomTrapOid" == *33555.3.0.53 ]] || [[ "$racomTrapOid" == *33555.3.0.54 ]] || [[ "$racomTrapOid" == *33555.3.0.55 ]] || [[ "$racomTrapOid" == *33555.3.0.56 ]] || [[ "$racomTrapOid" == *33555.3.0.57 ]] || [[ "$racomTrapOid" == *33555.3.0.58 ]] || [[ "$racomTrapOid" == *33555.3.0.68 ]] || [[ "$racomTrapOid" == *33555.3.0.69 ]] || [[ "$racomTrapOid" == *33555.3.0.71 ]] || [[ "$racomTrapOid" == *33555.3.0.72 ]] || [[ "$racomTrapOid" == *33555.3.0.74 ]] || [[ "$racomTrapOid" == *33555.3.0.75 ]] || [[ "$racomTrapOid" == *33555.3.0.76 ]] || [[ "$racomTrapOid" == *33555.3.0.77 ]] || [[ "$racomTrapOid" == *33555.3.0.81 ]] || [[ "$racomTrapOid" == *33555.3.0.83 ]] || [[ "$racomTrapOid" == *33555.3.0.86 ]] || [[ "$racomTrapOid" == *33555.3.0.87 ]] || [[ "$racomTrapOid" == *33555.3.0.88 ]] || [[ "$racomTrapOid" == *33555.3.0.89 ]] || [[ "$racomTrapOid" == *33555.3.0.90 ]] || [[ "$racomTrapOid" == *33555.3.0.92 ]] || [[ "$racomTrapOid" == *33555.3.0.95 ]] ; then

		# Status
		value2state[1]="OFF (na)"
		value2state[2]="ON (raise)"
		value2state[3]="OFF (clear)"
		value2state[4]="OFF (manualClear)"

		if [[ "$secondParValue" == "raise" ]]; then
			secondParValue="ALARM ON ($secondParValue)"
		else
			secondParValue="ALARM OFF ($secondParValue)"
		fi
		
		str="$secondParValue; Severity: $firstParValue, Additional information: $thirdParValue $fourthParValue $fifthParValue";
	else 
		# is NOT with STATUS information
		if [[ "$racomTrapOid" == *1.1.5.1* ]]; then
			str="Cold Start";
		elif [[ "$racomTrapOid" == *8072.4.0.2* ]]; then
			str="Shut Down";
		else
			str="Severity: $firstParValue, Additional information: $secondParValue $thirdParValue $fourthParValue $fifthParValue";
		fi
	fi
else 
	# Other products section
	# If the received trap is DQ or RSS then change the KEY to KEY+RemoteIP
	# The remote IP must be without "" signs (first and last character)
	if [ "$KEY" = "trpDq" ] || [ "$KEY" = "trpRss" ]; then
		thirdParValue=${thirdParValue:1:(${#thirdParValue}-2)}	
		KEY=$KEY$thirdParValue
		echo "New KEY = $KEY" >> ${LOGFILE}
	fi
	
	# 2019-01-08 TM: RipEX traps testing
	if [[ "$firstParValue" == "inactive" ]] || [[ "$firstParValue" == "off" ]]; then
		firstParValue="OFF"
	elif [[ "$firstParValue" == "active" ]] || [[ "$firstParValue" == "on" ]]; then
		firstParValue="ON"
	fi
	
	# 2017-08-02
	# Declare an array with the RipEX Alternative Path states
	# To enable mapping, add mibs +/usr/share/snmp/mibs/RACOM-RipEX-1.0.4.0.mib to /etc/snmp/snmp.conf
	value2state[0]="Unknown"
	value2state[1]="Up"
	value2state[2]="Down"
	
	# Explanation
	# 2019-01-08 TM: RipEX traps testing
	if [ $secondParValue = "down" ]; then
		secondParValue="DOWN"
	elif [ $secondParValue = "up" ]; then
		secondParValue="UP"
	fi
	
	# Create a string with all needed information - can be easily edited
	# See the comments to know which if/then/else branch corresponds to which trap
	
	if [ "$NUMBER_OF_VARS" -eq 3 ]; then
		if [[ "$racomTrapOid" == *33555.10.100.0* ]]; then
			# M!DGE, MG102i traps
			str="KEY: $KEY, Description: ${oid2desc[$racomTrapOid]}";
		else
			# RipEX - trpRss, trpDq
			str="ALARM: $firstParValue, WatchedValue VALUE: $secondParValue, Remote IP address: $thirdParValue";
		fi
	elif [ "$NUMBER_OF_VARS" -eq 2 ] && [[ "$racomTrapOid" == *33555.10.100.0* ]]; then
		# M!DGE2
		 str="KEY: $KEY, Description: ${oid2desc[$racomTrapOid]}"; 
	elif [ "$NUMBER_OF_VARS" -eq 5 ]; then
		if [[ "$racomTrapOid" == *33555.1.10.0* ]]; then
	                # RAy10
	                str="Description: ${oid2desc[$racomTrapOid]}, ALARM value: $firstParValue";
		else
			# RipEX - trpBpath, trpBpathAlt
			str="Peer IP address: $firstParValue, Symbolic name: $secondParValue, Priority number: $thirdParValue, Gateway IP address: $fourthParValue, Current state: $fifthParValue";
		fi
	else
		if [ "$KEY" == "trpHotStby" ]; then
			# RipEX - trpHotStby
			str="Active HotStandBy unit name: $secondParValue, serial number: $firstParValue";
		fi
	
		if [[ "$racomTrapOid" == *33555.1.10* ]]; then
			# RAy1 - these traps will stay active only defined number of seconds in the Zabbix front-end. RAy does not send "OK" traps. 
			str="Description: ${oid2desc[$racomTrapOid]}, ALARM value: $firstParValue";
		fi
	
		if [[ "$racomTrapOid" == *33555.1.11* ]] || [[ "$racomTrapOid" == *33555.1.12* ]] || [[ "$racomTrapOid" == *33555.4.12* ]]; then
			# RAy2, RAy3
			if [[ "$racomTrapOid" == *101* ]]; then
				# air capacity
				str="WatchedValue value: $firstParValue kbps, Description: ${oid2desc[$racomTrapOid]}";
			elif [[ "$racomTrapOid" == *102* ]]; then
				# LSP alarm
				str="ALARM: $firstParValue, WatchedValue value: $secondParValue";
			else 
				str="ALARM: $secondParValue, WatchedValue value: $firstParValue, Description: ${oid2desc[$racomTrapOid]}";
			fi
		else 
			if [[ "$racomTrapOid" == *33555.2.10.17* ]] || [[ "$racomTrapOid" == *33555.2.10.18* ]]; then
				# RipEX - trpUnitReady, trpNomadOffline
				str="ALARM: $firstParValue, UPTIME: $uptime";
			else
				# RipEX - trpVswr, trpUcc, ...
				str="ALARM: $firstParValue, WatchedValue VALUE: $secondParValue";
			fi
		fi
	fi
fi

# Send the information to the Zabbix server
$ZABBIX_SENDER -z $ZABBIX_SERVER -p $ZABBIX_PORT -s "$host" -k "$KEY" -o "$str"
echo "$ZABBIX_SENDER -z $ZABBIX_SERVER -p $ZABBIX_PORT -s $host -k $KEY -o $str" >> ${LOGFILE}
